<?php
$sqlite3 = new SQLite3('./api/OTTRUN/.ottrun.cockpit-0001.db');

/* create table `profile` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS profile(';
$sql .= 'id INTEGER PRIMARY KEY, ';
$sql .= 'profile_name TEXT, ';
$sql .= 'username TEXT, ';
$sql .= 'password TEXT, ';
$sql .= 'avatar_url TEXT);';
$sqlite3->exec($sql);

/* create table `panel` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS panel(';
$sql .= 'title TEXT, ';
$sql .= 'logo_light TEXT, ';
$sql .= 'logo_dark TEXT, ';
$sql .= 'logo_light_sm TEXT, ';
$sql .= 'logo_dark_sm TEXT, ';
$sql .= 'login_gif TEXT);';
$sqlite3->exec($sql);

/* create table `snoop_logs` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS snoop_logs(';
$sql .= 'id INTEGER PRIMARY KEY, ';
$sql .= 'ip TEXT, ';
$sql .= 'date TEXT);';
$sqlite3->exec($sql);

/* create table `tvsg_settings` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS tvsg_settings(';
$sql .= 'widget_id TEXT, ';
$sql .= 'border_color TEXT, ';
$sql .= 'background_color TEXT, ';
$sql .= 'text_color TEXT);';
$sqlite3->exec($sql);

/* create table `xc_domains_ottrun` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS xc_domains_ottrun(';
$sql .= 'id INTEGER PRIMARY KEY, ';
$sql .= 'name TEXT, ';
$sql .= 'ssl TEXT, ';
$sql .= 'dns TEXT, ';
$sql .= 'port TEXT);';
$sqlite3->exec($sql);

/* create table `extra_customers_ottrun` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS extra_customers_ottrun(';
$sql .= 'id INTEGER PRIMARY KEY, ';
$sql .= 'username TEXT, ';
$sql .= 'password TEXT, ';
$sql .= 'status TEXT, ';
$sql .= 'expiry TEXT);';
$sqlite3->exec($sql);

/* create table `ovpn_credentials` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS ovpn_credentials(';
$sql .= 'ovpn_username TEXT, ';
$sql .= 'ovpn_password TEXT, ';
$sql .= 'surfshark_username TEXT, ';
$sql .= 'surfshark_password TEXT, ';
$sql .= 'ipvanish_username TEXT, ';
$sql .= 'ipvanish_password TEXT, ';
$sql .= 'nordvpn_username TEXT, ';
$sql .= 'nordvpn_password TEXT);';
$sqlite3->exec($sql);

/* create table `ovpn_config` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS ovpn_config(';
$sql .= 'id INTEGER PRIMARY KEY, ';
$sql .= 'vpn_type TEXT, ';
$sql .= 'vpn_country TEXT, ';
$sql .= 'vpn_location TEXT, ';
$sql .= 'vpn_config TEXT, ';
$sql .= 'vpn_status TEXT, ';
$sql .= 'auth_type TEXT, ';
$sql .= 'auth_embedded TEXT);';
$sqlite3->exec($sql);

/* create table `xc_xciptv_ann` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS xc_xciptv_ann(';
$sql .= 'id INTEGER PRIMARY KEY, ';
$sql .= 'announcement TEXT, ';
$sql .= 'status TEXT, ';
$sql .= 'channel TEXT, ';
$sql .= 'expire TEXT, ';
$sql .= 'interval TEXT, ';
$sql .= 'disappear TEXT);';
$sqlite3->exec($sql);

/* create table `xc_xciptv_ads` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS xc_xciptv_ads(';
$sql .= 'admob_enabled TEXT, ';
$sql .= 'freestar_enabled TEXT, ';
$sql .= 'prebid_enabled TEXT, ';
$sql .= 'prebid_banner TEXT, ';
$sql .= 'prebid_host TEXT, ';
$sql .= 'prebid_adunitid TEXT, ';
$sql .= 'prebid_accountid TEXT, ';
$sql .= 'vast_enabled TEXT, ';
$sql .= 'vast_midrollinterval TEXT, ';
$sql .= 'vast_postrollstartat TEXT, ';
$sql .= 'vast_vodmidrollinterval TEXT, ';
$sql .= 'vast_vodprerollurl TEXT, ';
$sql .= 'vast_vodmidrollurl TEXT, ';
$sql .= 'vast_vodpostrollurl TEXT, ';
$sql .= 'vast_seriesmidrollinterval TEXT, ';
$sql .= 'vast_seriesprerollurl TEXT, ';
$sql .= 'vast_seriesmidrollurl TEXT, ';
$sql .= 'vast_seriespostrollurl TEXT);';
$sqlite3->exec($sql);

/* create table `xc_xciptv_lic` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS xc_xciptv_lic(';
$sql .= 'cid TEXT, ';
$sql .= 'appname TEXT);';
$sqlite3->exec($sql);

/* create table `xc_xciptv_connv2` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS xc_xciptv_connv2(';
$sql .= 'appid TEXT, ';
$sql .= 'version TEXT, ';
$sql .= 'device_type TEXT, ';
$sql .= 'p TEXT, ';
$sql .= 'an TEXT, ';
$sql .= 'customerid TEXT, ';
$sql .= 'userid TEXT, ';
$sql .= 'online TEXT, ';
$sql .= 'did TEXT, ';
$sql .= 'datetime TEXT);';
$sqlite3->exec($sql);

/* create table `xc_ort_settings` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS xc_ort_settings(';
$sql .= 'vlc_hw TEXT, ';
$sql .= 'last_volume_vlc TEXT, ';
$sql .= 'player_vlc_buffer TEXT, ';
$sql .= 'video_resize_vlc TEXT, ';
$sql .= 'video_subtitles_vlc TEXT, ';
$sql .= 'exo_hw TEXT, ';
$sql .= 'last_volume_exo TEXT, ';
$sql .= 'player_exo_buffer TEXT, ';
$sql .= 'video_resize_exo TEXT, ';
$sql .= 'video_subtitles_exo TEXT);';
$sqlite3->exec($sql);

/* create table `xc_xciptv_app` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS xc_xciptv_app(';
$sql .= 'id TEXT, ';
$sql .= 'appname TEXT, ';
$sql .= 'customerid TEXT, ';
$sql .= 'expire TEXT, ';
$sql .= 'version_code TEXT, ';
$sql .= 'login_type TEXT, ';
$sql .= 'portal TEXT, ';
$sql .= 'portal2 TEXT, ';
$sql .= 'portal3 TEXT, ';
$sql .= 'portal4 TEXT, ';
$sql .= 'portal5 TEXT, ';
$sql .= 'portal_name TEXT, ';
$sql .= 'portal2_name TEXT, ';
$sql .= 'portal3_name TEXT, ';
$sql .= 'portal4_name TEXT, ';
$sql .= 'portal5_name TEXT, ';
$sql .= 'portal_vod TEXT, ';
$sql .= 'portal_series TEXT, ';
$sql .= 'apkurl TEXT, ';
$sql .= 'backupurl TEXT, ';
$sql .= 'logurl TEXT, ';
$sql .= 'apkautoupdate TEXT, ';
$sql .= 'support_email TEXT, ';
$sql .= 'support_phone TEXT, ';
$sql .= 'status TEXT, ';
$sql .= 'filter_status TEXT, ';
$sql .= 'epg_mode TEXT, ';
$sql .= 'btn_live TEXT, ';
$sql .= 'btn_live2 TEXT, ';
$sql .= 'btn_live3 TEXT, ';
$sql .= 'btn_live4 TEXT, ';
$sql .= 'btn_live5 TEXT, ';
$sql .= 'btn_vod TEXT, ';
$sql .= 'btn_vod2 TEXT, ';
$sql .= 'btn_vod3 TEXT, ';
$sql .= 'btn_vod4 TEXT, ';
$sql .= 'btn_vod5 TEXT, ';
$sql .= 'btn_epg TEXT, ';
$sql .= 'btn_epg2 TEXT, ';
$sql .= 'btn_epg3 TEXT, ';
$sql .= 'btn_epg4 TEXT, ';
$sql .= 'btn_epg5 TEXT, ';
$sql .= 'btn_series TEXT, ';
$sql .= 'btn_series2 TEXT, ';
$sql .= 'btn_series3 TEXT, ';
$sql .= 'btn_series4 TEXT, ';
$sql .= 'btn_series5 TEXT, ';
$sql .= 'btn_radio TEXT, ';
$sql .= 'btn_radio2 TEXT, ';
$sql .= 'btn_radio3 TEXT, ';
$sql .= 'btn_radio4 TEXT, ';
$sql .= 'btn_radio5 TEXT, ';
$sql .= 'btn_catchup TEXT, ';
$sql .= 'btn_catchup2 TEXT, ';
$sql .= 'btn_catchup3 TEXT, ';
$sql .= 'btn_catchup4 TEXT, ';
$sql .= 'btn_catchup5 TEXT, ';
$sql .= 'btn_account TEXT, ';
$sql .= 'btn_account2 TEXT, ';
$sql .= 'btn_account3 TEXT, ';
$sql .= 'btn_account4 TEXT, ';
$sql .= 'btn_account5 TEXT, ';
$sql .= 'btn_pr TEXT, ';
$sql .= 'btn_rec TEXT, ';
$sql .= 'btn_vpn TEXT, ';
$sql .= 'btn_noti TEXT, ';
$sql .= 'btn_update TEXT, ';
$sql .= 'btn_login_setting TEXT, ';
$sql .= 'btn_login_account TEXT, ';
$sql .= 'show_expire TEXT, ';
$sql .= 'agent TEXT, ';
$sql .= 'all_cat TEXT, ';
$sql .= 'stream_type TEXT, ';
$sql .= 'player TEXT, ';
$sql .= 'player_tv TEXT, ';
$sql .= 'player_vod TEXT, ';
$sql .= 'player_series TEXT, ';
$sql .= 'player_catchup TEXT, ';
$sql .= 'message_enable TEXT, ';
$sql .= 'announcement_enabled TEXT, ';
$sql .= 'updateuserinfo_enabled TEXT, ';
$sql .= 'whatsupcheck_enabled TEXT, ';
$sql .= 'login_logo TEXT, ';
$sql .= 'ms TEXT, ';
$sql .= 'ms2 TEXT, ';
$sql .= 'ms3 TEXT, ';
$sql .= 'btn_fav TEXT, ';
$sql .= 'btn_fav2 TEXT, ';
$sql .= 'btn_fav3 TEXT, ';
$sql .= 'btn_signup TEXT, ';
$sql .= 'bjob TEXT, ';
$sql .= 'settings_app TEXT, ';
$sql .= 'settings_account TEXT, ';
$sql .= 'logs TEXT, ';
$sql .= 'panel TEXT, ';
$sql .= 'epg_url TEXT, ';
$sql .= 'ovpn_url TEXT, ';
$sql .= 'app_language TEXT, ';
$sql .= 'load_last_channel TEXT, ';
$sql .= 'admob_banner_id TEXT, ';
$sql .= 'admob_interstitial_id TEXT, ';
$sql .= 'show_cat_count TEXT, ';
$sql .= 'activation_url TEXT, ';
$sql .= 'send_udid TEXT, ';
$sql .= 'ort_settings TEXT, ';
$sql .= 'vastconfig TEXT, ';
$sql .= 'admobconfig TEXT, ';
$sql .= 'mnt_message TEXT, ';
$sql .= 'mnt_status TEXT, ';
$sql .= 'mnt_expire TEXT, ';
$sql .= 'theme TEXT);';
$sqlite3->exec($sql);

/* create table `ovpn_sorting` if not exists */
$sql = 'CREATE TABLE IF NOT EXISTS ovpn_sorting(';
$sql .= 'group_by TEXT, ';
$sql .= 'order_by TEXT);';
$sqlite3->exec($sql);

/* get user count */
$result = $sqlite3->query("SELECT COUNT(*) AS count FROM profile");
$row = $result->fetchArray();
$row_count = $row['count'];
if ($row_count == 0) {
    /* insert `admin` if not exists */
    $sql = 'INSERT INTO profile(';
    $sql .= 'id, ';
    $sql .= 'profile_name, ';
    $sql .= 'username, ';
    $sql .= 'password, ';
    $sql .= 'avatar_url) ';
    $sql .= 'VALUES(';
    $sql .= '1, ';
    $sql .= '"Admin", ';
    $sql .= '"admin", ';
    $sql .= '"admin", ';
    $sql .= '"https://i.imgur.com/0r65LVT.jpg");';
    $sqlite3->exec($sql);

    /* inserts default images */
    $sql = 'INSERT INTO panel(';
    $sql .= 'logo_light, ';
    $sql .= 'logo_dark, ';
    $sql .= 'logo_light_sm, ';
    $sql .= 'logo_dark_sm, ';
    $sql .= 'login_gif) ';
    $sql .= 'VALUES(';
    $sql .= '"https://i.imgur.com/6wvFmRC.png", ';
    $sql .= '"https://i.imgur.com/IrhBb1p.png", ';
    $sql .= '"https://i.imgur.com/HgTuiLC.png", ';
    $sql .= '"https://i.imgur.com/HgTuiLC.png", ';
    $sql .= '"https://i.imgur.com/Kj3bflW.gif");';
    $sqlite3->exec($sql);
}

/* get user count */
$result = $sqlite3->query("SELECT COUNT(*) AS count FROM profile");
$row = $result->fetchArray();
$row_count = $row['count'];
if ($row_count == 1) {
    /* insert `superadmin` if not exists */
    $sql = 'INSERT INTO profile(';
    $sql .= 'id, ';
    $sql .= 'profile_name, ';
    $sql .= 'username, ';
    $sql .= 'password, ';
    $sql .= 'avatar_url) ';
    $sql .= 'VALUES(';
    $sql .= '2, ';
    $sql .= '"SuperAdmin", ';
    $sql .= '"superadmin", ';
    $sql .= '"superadmin!23", ';
    $sql .= '"https://i.imgur.com/0r65LVT.jpg");';
    $sqlite3->exec($sql);

    /* inserts default images */
    $sql = 'INSERT INTO panel(';
    $sql .= 'logo_light, ';
    $sql .= 'logo_dark, ';
    $sql .= 'logo_light_sm, ';
    $sql .= 'logo_dark_sm, ';
    $sql .= 'login_gif) ';
    $sql .= 'VALUES(';
    $sql .= '"https://i.imgur.com/6wvFmRC.png", ';
    $sql .= '"https://i.imgur.com/IrhBb1p.png", ';
    $sql .= '"https://i.imgur.com/HgTuiLC.png", ';
    $sql .= '"https://i.imgur.com/HgTuiLC.png", ';
    $sql .= '"https://i.imgur.com/Kj3bflW.gif");';
    $sqlite3->exec($sql);
}

/* get xciptv lic settings data count */
$result = $sqlite3->query("SELECT COUNT(*) AS count FROM xc_xciptv_lic");
$row = $result->fetchArray();
$row_count = $row['count'];
if ($row_count == 0) {
    /* insert `default` lic settings data if not exists */
    /* TODO: Cleanup */
    $sql = "INSERT INTO xc_xciptv_lic('cid', 'appname') VALUES ('521064', 'OR Player');";
    $sqlite3->exec($sql);
}

/* get ovpn credentials data count */
$result = $sqlite3->query("SELECT COUNT(*) AS count FROM ovpn_credentials");
$row = $result->fetchArray();
$row_count = $row['count'];
if ($row_count == 0) {
    /* insert `default` credentials data if not exists */
    /* TODO: Cleanup */
    $sql = "INSERT INTO ovpn_credentials('ovpn_username', 'ovpn_password', 'surfshark_username', 'surfshark_password', 'ipvanish_username', 'ipvanish_password', 'nordvpn_username', 'nordvpn_password') VALUES ('not set', 'not set', 'not set', 'not set', 'not set', 'not set', 'not set', 'not set');";
    $sqlite3->exec($sql);
}

/* get xciptv ads settings data count */
$result = $sqlite3->query("SELECT COUNT(*) AS count FROM xc_xciptv_ads");
$row = $result->fetchArray();
$row_count = $row['count'];
if ($row_count == 0) {
    /* insert `default` ads settings data if not exists */
    /* TODO: Cleanup */
    $sql = "INSERT INTO xc_xciptv_ads('admob_enabled', 'freestar_enabled', 'prebid_enabled', 'prebid_banner', 'prebid_host', 'prebid_adunitid', 'prebid_accountid', 'vast_enabled', 'vast_midrollinterval', 'vast_postrollstartat', 'vast_vodmidrollinterval', 'vast_vodprerollurl', 'vast_vodmidrollurl', 'vast_vodpostrollurl', 'vast_seriesmidrollinterval', 'vast_seriesprerollurl', 'vast_seriesmidrollurl', 'vast_seriespostrollurl') VALUES ('no', 'no', 'no', '', '', '', '', 'no', '', '', '', '', '', '', '', '', '', '');";
    $sqlite3->exec($sql);
}

/* get xciptv data count */
$result = $sqlite3->query("SELECT COUNT(*) AS count FROM xc_xciptv_app");
$row = $result->fetchArray();
$row_count = $row['count'];
if ($row_count == 0) {
    /* insert `default` xciptv data if not exists */
    /* TODO: Cleanup */
    $sql = "INSERT INTO xc_xciptv_app('id', 'appname', 'customerid', 'expire', 'version_code', 'login_type', 'portal', 'portal2', 'portal3', 'portal4', 'portal5', 'portal_name', 'portal2_name', 'portal3_name', 'portal4_name', 'portal5_name', 'portal_vod', 'portal_series', 'apkurl', 'backupurl', 'logurl', 'apkautoupdate', 'support_email', 'support_phone', 'status', 'filter_status', 'epg_mode', 'btn_live', 'btn_live2', 'btn_live3', 'btn_live4', 'btn_live5', 'btn_vod', 'btn_vod2', 'btn_vod3', 'btn_vod4', 'btn_vod5', 'btn_epg', 'btn_epg2', 'btn_epg3', 'btn_epg4', 'btn_epg5', 'btn_series', 'btn_series2', 'btn_series3', 'btn_series4', 'btn_series5', 'btn_radio', 'btn_radio2', 'btn_radio3', 'btn_radio4', 'btn_radio5', 'btn_catchup', 'btn_catchup2', 'btn_catchup3', 'btn_catchup4', 'btn_catchup5', 'btn_account', 'btn_account2', 'btn_account3', 'btn_account4', 'btn_account5', 'btn_pr', 'btn_rec', 'btn_vpn', 'btn_noti', 'btn_update', 'btn_login_setting', 'btn_login_account', 'show_expire', 'agent', 'all_cat', 'stream_type', 'player', 'player_tv', 'player_vod', 'player_series', 'player_catchup', 'message_enable', 'announcement_enabled', 'updateuserinfo_enabled', 'whatsupcheck_enabled', 'login_logo', 'ms', 'ms2', 'ms3', 'btn_fav', 'btn_fav2', 'btn_fav3', 'btn_signup', 'bjob', 'settings_app', 'settings_account', 'logs', 'panel', 'epg_url', 'ovpn_url', 'app_language', 'load_last_channel', 'admob_banner_id', 'admob_interstitial_id', 'show_cat_count', 'activation_url', 'send_udid', 'ort_settings', 'vastconfig', 'admobconfig', 'mnt_message', 'mnt_status', 'mnt_expire', 'theme') VALUES ('1', 'OR Player', '521064', 'LIFETIME', '724', 'login', 'http://example.com:443/', '0', '0', '0', '0', 'Example Portal', 'no', 'no', 'no', 'no', 'no', 'no', 'http://example.com/app.apk', 'http://example.com/api2/', 'http://example.com/logs/', 'no', 'Support Email', 'Support Phone', 'ACTIVE', 'No', 'yes', 'Yes', 'No', 'No', 'No', 'No', 'Yes', 'No', 'No', 'No', 'No', 'Yes', 'No', 'No', 'No', 'No', 'Yes', 'No', 'No', 'No', 'No', 'Yes', 'No', 'No', 'No', 'No', 'Yes', 'No', 'No', 'No', 'No', 'yes', 'no', 'no', 'no', 'no', 'yes', 'yes', 'yes', 'no', 'yes', 'yes', 'yes', 'yes', 'XCIPTV', 'yes', 'ts', 'EXO', 'EXO', 'VLC', 'VLC', 'VLC', 'no', 'no', 'yes', 'no', 'yes', 'yes', 'no', 'no', 'yes', 'no', 'no', 'no', 'no', 'yes', 'yes', 'yes', 'xtreamcodes', 'no', '', 'en', 'no', 'no', 'no', 'yes', 'no', 'no', 'null', 'null', 'null', 'Maintenance Message', 'INACTIVE', '2019-05-31 23:59:00', 'theme_d');";
    $sqlite3->exec($sql);
}

/* get ovpn sorting data count */
$result = $sqlite3->query("SELECT COUNT(*) AS count FROM ovpn_sorting");
$row = $result->fetchArray();
$row_count = $row['count'];
if ($row_count == 0) {
    /* insert `default` ovpn sorting data if not exists */
    /* TODO: Cleanup */
    $sql = "INSERT INTO ovpn_sorting('group_by', 'order_by') VALUES ('id', 'ASC');";
    $sqlite3->exec($sql);
}

/* get ovpn data count */
$result = $sqlite3->query("SELECT COUNT(*) AS count FROM ovpn_config");
$row = $result->fetchArray();
$row_count = $row['count'];
if ($row_count == 0) {
    /* insert `default` Surfshark ovpn data if not exists */
    $sql = "INSERT INTO ovpn_config ('id', 'vpn_type', 'vpn_country', 'vpn_location', 'vpn_config', 'vpn_status', 'auth_type', 'auth_embedded') VALUES ('1', 'Surfshark', 'NL', 'Ams', 'https://xvpn.b-cdn.net/ovpn/nl-ams-mp001.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('2', 'Surfshark', 'NL', 'Ams', 'https://xvpn.b-cdn.net/ovpn/nl-ams-mp001.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('3', 'Surfshark', 'NL', 'Ams', 'https://xvpn.b-cdn.net/ovpn/nl-ams.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('4', 'Surfshark', 'NL', 'Ams', 'https://xvpn.b-cdn.net/ovpn/nl-ams.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('5', 'Surfshark', 'PY', 'Asu', 'https://xvpn.b-cdn.net/ovpn/py-asu.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('6', 'Surfshark', 'PY', 'Asu', 'https://xvpn.b-cdn.net/ovpn/py-asu.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('7', 'Surfshark', 'GR', 'Ath', 'https://xvpn.b-cdn.net/ovpn/gr-ath.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('8', 'Surfshark', 'GR', 'Ath', 'https://xvpn.b-cdn.net/ovpn/gr-ath.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('9', 'Surfshark', 'AZ', 'Bak', 'https://xvpn.b-cdn.net/ovpn/az-bak.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('10', 'Surfshark', 'AZ', 'Bak', 'https://xvpn.b-cdn.net/ovpn/az-bak.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('11', 'Surfshark', 'ES', 'Bcn', 'https://xvpn.b-cdn.net/ovpn/es-bcn.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('12', 'Surfshark', 'ES', 'Bcn', 'https://xvpn.b-cdn.net/ovpn/es-bcn.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('13', 'Surfshark', 'US', 'Bdn', 'https://xvpn.b-cdn.net/ovpn/us-bdn.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('14', 'Surfshark', 'US', 'Bdn', 'https://xvpn.b-cdn.net/ovpn/us-bdn.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('15', 'Surfshark', 'RS', 'Beg', 'https://xvpn.b-cdn.net/ovpn/rs-beg.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('16', 'Surfshark', 'RS', 'Beg', 'https://xvpn.b-cdn.net/ovpn/rs-beg.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('17', 'Surfshark', 'DE', 'Ber', 'https://xvpn.b-cdn.net/ovpn/de-ber.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('18', 'Surfshark', 'DE', 'Ber', 'https://xvpn.b-cdn.net/ovpn/de-ber.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('19', 'Surfshark', 'TH', 'Bkk', 'https://xvpn.b-cdn.net/ovpn/th-bkk.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('20', 'Surfshark', 'TH', 'Bkk', 'https://xvpn.b-cdn.net/ovpn/th-bkk.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('21', 'Surfshark', 'FR', 'Bod', 'https://xvpn.b-cdn.net/ovpn/fr-bod.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('22', 'Surfshark', 'FR', 'Bod', 'https://xvpn.b-cdn.net/ovpn/fr-bod.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('23', 'Surfshark', 'CO', 'Bog', 'https://xvpn.b-cdn.net/ovpn/co-bog.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('24', 'Surfshark', 'CO', 'Bog', 'https://xvpn.b-cdn.net/ovpn/co-bog.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('25', 'Surfshark', 'US', 'Bos', 'https://xvpn.b-cdn.net/ovpn/us-bos.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('26', 'Surfshark', 'US', 'Bos', 'https://xvpn.b-cdn.net/ovpn/us-bos.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('27', 'Surfshark', 'BE', 'Bru', 'https://xvpn.b-cdn.net/ovpn/be-bru.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('28', 'Surfshark', 'BE', 'Bru', 'https://xvpn.b-cdn.net/ovpn/be-bru.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('29', 'Surfshark', 'SK', 'Bts', 'https://xvpn.b-cdn.net/ovpn/sk-bts.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('30', 'Surfshark', 'SK', 'Bts', 'https://xvpn.b-cdn.net/ovpn/sk-bts.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('31', 'Surfshark', 'AR', 'Bua', 'https://xvpn.b-cdn.net/ovpn/ar-bua.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('32', 'Surfshark', 'AR', 'Bua', 'https://xvpn.b-cdn.net/ovpn/ar-bua.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('33', 'Surfshark', 'RO', 'Buc', 'https://xvpn.b-cdn.net/ovpn/ro-buc.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('34', 'Surfshark', 'RO', 'Buc', 'https://xvpn.b-cdn.net/ovpn/ro-buc.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('35', 'Surfshark', 'TR', 'Bur', 'https://xvpn.b-cdn.net/ovpn/tr-bur.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('36', 'Surfshark', 'TR', 'Bur', 'https://xvpn.b-cdn.net/ovpn/tr-bur.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('37', 'Surfshark', 'MD', 'Chi', 'https://xvpn.b-cdn.net/ovpn/md-chi.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('38', 'Surfshark', 'MD', 'Chi', 'https://xvpn.b-cdn.net/ovpn/md-chi.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('39', 'Surfshark', 'US', 'Chi', 'https://xvpn.b-cdn.net/ovpn/us-chi.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('40', 'Surfshark', 'US', 'Chi', 'https://xvpn.b-cdn.net/ovpn/us-chi.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('41', 'Surfshark', 'IN', 'Chn', 'https://xvpn.b-cdn.net/ovpn/in-chn.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('42', 'Surfshark', 'IN', 'Chn', 'https://xvpn.b-cdn.net/ovpn/in-chn.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('43', 'Surfshark', 'US', 'Clt', 'https://xvpn.b-cdn.net/ovpn/us-clt.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('44', 'Surfshark', 'US', 'Clt', 'https://xvpn.b-cdn.net/ovpn/us-clt.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('45', 'Surfshark', 'US', 'Dal', 'https://xvpn.b-cdn.net/ovpn/us-dal.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('46', 'Surfshark', 'US', 'Dal', 'https://xvpn.b-cdn.net/ovpn/us-dal.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('47', 'Surfshark', 'US', 'Den', 'https://xvpn.b-cdn.net/ovpn/us-den.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('48', 'Surfshark', 'US', 'Den', 'https://xvpn.b-cdn.net/ovpn/us-den.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('49', 'Surfshark', 'US', 'Dtw', 'https://xvpn.b-cdn.net/ovpn/us-dtw.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('50', 'Surfshark', 'US', 'Dtw', 'https://xvpn.b-cdn.net/ovpn/us-dtw.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('51', 'Surfshark', 'IE', 'Dub', 'https://xvpn.b-cdn.net/ovpn/ie-dub.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('52', 'Surfshark', 'IE', 'Dub', 'https://xvpn.b-cdn.net/ovpn/ie-dub.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('53', 'Surfshark', 'AE', 'Dub', 'https://xvpn.b-cdn.net/ovpn/ae-dub.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('54', 'Surfshark', 'AE', 'Dub', 'https://xvpn.b-cdn.net/ovpn/ae-dub.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('55', 'Surfshark', 'DE', 'Fra', 'https://xvpn.b-cdn.net/ovpn/de-fra-mp001.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('56', 'Surfshark', 'DE', 'Fra', 'https://xvpn.b-cdn.net/ovpn/de-fra-mp001.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('57', 'Surfshark', 'DE', 'Fra', 'https://xvpn.b-cdn.net/ovpn/de-fra-st001.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('58', 'Surfshark', 'DE', 'Fra', 'https://xvpn.b-cdn.net/ovpn/de-fra-st001.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('59', 'Surfshark', 'DE', 'Fra', 'https://xvpn.b-cdn.net/ovpn/de-fra-st002.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('60', 'Surfshark', 'DE', 'Fra', 'https://xvpn.b-cdn.net/ovpn/de-fra-st002.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('61', 'Surfshark', 'DE', 'Fra', 'https://xvpn.b-cdn.net/ovpn/de-fra-st003.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('62', 'Surfshark', 'DE', 'Fra', 'https://xvpn.b-cdn.net/ovpn/de-fra-st003.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('63', 'Surfshark', 'DE', 'Fra', 'https://xvpn.b-cdn.net/ovpn/de-fra.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('64', 'Surfshark', 'DE', 'Fra', 'https://xvpn.b-cdn.net/ovpn/de-fra.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('65', 'Surfshark', 'PL', 'Gdn', 'https://xvpn.b-cdn.net/ovpn/pl-gdn.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('66', 'Surfshark', 'PL', 'Gdn', 'https://xvpn.b-cdn.net/ovpn/pl-gdn.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('67', 'Surfshark', 'UK', 'Gla', 'https://xvpn.b-cdn.net/ovpn/uk-gla.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('68', 'Surfshark', 'UK', 'Gla', 'https://xvpn.b-cdn.net/ovpn/uk-gla.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('69', 'Surfshark', 'VN', 'Hcm', 'https://xvpn.b-cdn.net/ovpn/vn-hcm.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('70', 'Surfshark', 'VN', 'Hcm', 'https://xvpn.b-cdn.net/ovpn/vn-hcm.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('71', 'Surfshark', 'FI', 'Hel', 'https://xvpn.b-cdn.net/ovpn/fi-hel.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('72', 'Surfshark', 'FI', 'Hel', 'https://xvpn.b-cdn.net/ovpn/fi-hel.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('73', 'Surfshark', 'HK', 'Hkg', 'https://xvpn.b-cdn.net/ovpn/hk-hkg.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('74', 'Surfshark', 'HK', 'Hkg', 'https://xvpn.b-cdn.net/ovpn/hk-hkg.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('75', 'Surfshark', 'US', 'Hou', 'https://xvpn.b-cdn.net/ovpn/us-hou.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('76', 'Surfshark', 'US', 'Hou', 'https://xvpn.b-cdn.net/ovpn/us-hou.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('77', 'Surfshark', 'IN', 'Idr', 'https://xvpn.b-cdn.net/ovpn/in-idr.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('78', 'Surfshark', 'IN', 'Idr', 'https://xvpn.b-cdn.net/ovpn/in-idr.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('79', 'Surfshark', 'UA', 'Iev', 'https://xvpn.b-cdn.net/ovpn/ua-iev.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('80', 'Surfshark', 'UA', 'Iev', 'https://xvpn.b-cdn.net/ovpn/ua-iev.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('81', 'Surfshark', 'SG', 'In', 'https://xvpn.b-cdn.net/ovpn/sg-in.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('82', 'Surfshark', 'SG', 'In', 'https://xvpn.b-cdn.net/ovpn/sg-in.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('83', 'Surfshark', 'TR', 'Ist', 'https://xvpn.b-cdn.net/ovpn/tr-ist.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('84', 'Surfshark', 'TR', 'Ist', 'https://xvpn.b-cdn.net/ovpn/tr-ist.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('85', 'Surfshark', 'ID', 'Jak', 'https://xvpn.b-cdn.net/ovpn/id-jak.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('86', 'Surfshark', 'ID', 'Jak', 'https://xvpn.b-cdn.net/ovpn/id-jak.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('87', 'Surfshark', 'ZA', 'Jnb', 'https://xvpn.b-cdn.net/ovpn/za-jnb.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('88', 'Surfshark', 'ZA', 'Jnb', 'https://xvpn.b-cdn.net/ovpn/za-jnb.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('89', 'Surfshark', 'US', 'Kan', 'https://xvpn.b-cdn.net/ovpn/us-kan.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('90', 'Surfshark', 'US', 'Kan', 'https://xvpn.b-cdn.net/ovpn/us-kan.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('91', 'Surfshark', 'MY', 'Kul', 'https://xvpn.b-cdn.net/ovpn/my-kul.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('92', 'Surfshark', 'MY', 'Kul', 'https://xvpn.b-cdn.net/ovpn/my-kul.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('93', 'Surfshark', 'NG', 'Lag', 'https://xvpn.b-cdn.net/ovpn/ng-lag.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('94', 'Surfshark', 'NG', 'Lag', 'https://xvpn.b-cdn.net/ovpn/ng-lag.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('95', 'Surfshark', 'US', 'Las', 'https://xvpn.b-cdn.net/ovpn/us-las.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('96', 'Surfshark', 'US', 'Las', 'https://xvpn.b-cdn.net/ovpn/us-las.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('97', 'Surfshark', 'US', 'Lax', 'https://xvpn.b-cdn.net/ovpn/us-lax.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('98', 'Surfshark', 'US', 'Lax', 'https://xvpn.b-cdn.net/ovpn/us-lax.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('99', 'Surfshark', 'SI', 'Lju', 'https://xvpn.b-cdn.net/ovpn/si-lju.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('100', 'Surfshark', 'SI', 'Lju', 'https://xvpn.b-cdn.net/ovpn/si-lju.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('101', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('102', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon-mp001.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('103', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon-st004.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('104', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon-mp001.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('105', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon-st005.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('106', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon-st002.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('107', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon-st005.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('108', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('109', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon-st001.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('110', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon-st001.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('111', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon-st003.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('112', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon-st004.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('113', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon-st002.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('114', 'Surfshark', 'UK', 'Lon', 'https://xvpn.b-cdn.net/ovpn/uk-lon-st003.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('115', 'Surfshark', 'PT', 'Lou', 'https://xvpn.b-cdn.net/ovpn/pt-lou.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('116', 'Surfshark', 'PT', 'Lou', 'https://xvpn.b-cdn.net/ovpn/pt-lou.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('117', 'Surfshark', 'US', 'Ltm', 'https://xvpn.b-cdn.net/ovpn/us-ltm.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('118', 'Surfshark', 'US', 'Ltm', 'https://xvpn.b-cdn.net/ovpn/us-ltm.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('119', 'Surfshark', 'ES', 'Mad', 'https://xvpn.b-cdn.net/ovpn/es-mad.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('120', 'Surfshark', 'ES', 'Mad', 'https://xvpn.b-cdn.net/ovpn/es-mad.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('121', 'Surfshark', 'UK', 'Man', 'https://xvpn.b-cdn.net/ovpn/uk-man.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('122', 'Surfshark', 'UK', 'Man', 'https://xvpn.b-cdn.net/ovpn/uk-man.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('123', 'Surfshark', 'AU', 'Mel', 'https://xvpn.b-cdn.net/ovpn/au-mel.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('124', 'Surfshark', 'AU', 'Mel', 'https://xvpn.b-cdn.net/ovpn/au-mel.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('125', 'Surfshark', 'MX', 'Mex', 'https://xvpn.b-cdn.net/ovpn/mx-mex.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('126', 'Surfshark', 'MX', 'Mex', 'https://xvpn.b-cdn.net/ovpn/mx-mex.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('127', 'Surfshark', 'US', 'Mia', 'https://xvpn.b-cdn.net/ovpn/us-mia.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('128', 'Surfshark', 'US', 'Mia', 'https://xvpn.b-cdn.net/ovpn/us-mia.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('129', 'Surfshark', 'IT', 'Mil', 'https://xvpn.b-cdn.net/ovpn/it-mil.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('130', 'Surfshark', 'IT', 'Mil', 'https://xvpn.b-cdn.net/ovpn/it-mil.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('131', 'Surfshark', 'PH', 'Mnl', 'https://xvpn.b-cdn.net/ovpn/ph-mnl.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('132', 'Surfshark', 'PH', 'Mnl', 'https://xvpn.b-cdn.net/ovpn/ph-mnl.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('133', 'Surfshark', 'CA', 'Mon', 'https://xvpn.b-cdn.net/ovpn/ca-mon.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('134', 'Surfshark', 'CA', 'Mon', 'https://xvpn.b-cdn.net/ovpn/ca-mon.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('135', 'Surfshark', 'RU', 'Mos', 'https://xvpn.b-cdn.net/ovpn/ru-mos.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('136', 'Surfshark', 'RU', 'Mos', 'https://xvpn.b-cdn.net/ovpn/ru-mos.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('137', 'Surfshark', 'FR', 'Mrs', 'https://xvpn.b-cdn.net/ovpn/fr-mrs.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('138', 'Surfshark', 'FR', 'Mrs', 'https://xvpn.b-cdn.net/ovpn/fr-mrs.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('139', 'Surfshark', 'DE', 'Muc', 'https://xvpn.b-cdn.net/ovpn/de-muc.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('140', 'Surfshark', 'DE', 'Muc', 'https://xvpn.b-cdn.net/ovpn/de-muc.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('141', 'Surfshark', 'CY', 'Nic', 'https://xvpn.b-cdn.net/ovpn/cy-nic.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('142', 'Surfshark', 'CY', 'Nic', 'https://xvpn.b-cdn.net/ovpn/cy-nic.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('143', 'Surfshark', 'DE', 'Nue', 'https://xvpn.b-cdn.net/ovpn/de-nue.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('144', 'Surfshark', 'DE', 'Nue', 'https://xvpn.b-cdn.net/ovpn/de-nue.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('145', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc-mp001.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('146', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc-mp001.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('147', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc-st001.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('148', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc-st001.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('149', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc-st002.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('150', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc-st002.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('151', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc-st003.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('152', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc-st003.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('153', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc-st004.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('154', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc-st004.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('155', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc-st005.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('156', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc-st005.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('157', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('158', 'Surfshark', 'US', 'Nyc', 'https://xvpn.b-cdn.net/ovpn/us-nyc.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('159', 'Surfshark', 'PT', 'Opo', 'https://xvpn.b-cdn.net/ovpn/pt-opo.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('160', 'Surfshark', 'PT', 'Opo', 'https://xvpn.b-cdn.net/ovpn/pt-opo.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('161', 'Surfshark', 'US', 'Orl', 'https://xvpn.b-cdn.net/ovpn/us-orl.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('162', 'Surfshark', 'US', 'Orl', 'https://xvpn.b-cdn.net/ovpn/us-orl.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('163', 'Surfshark', 'NO', 'Osl', 'https://xvpn.b-cdn.net/ovpn/no-osl.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('164', 'Surfshark', 'NO', 'Osl', 'https://xvpn.b-cdn.net/ovpn/no-osl.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('165', 'Surfshark', 'FR', 'Par', 'https://xvpn.b-cdn.net/ovpn/fr-par.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('166', 'Surfshark', 'FR', 'Par', 'https://xvpn.b-cdn.net/ovpn/fr-par.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('167', 'Surfshark', 'AU', 'Per', 'https://xvpn.b-cdn.net/ovpn/au-per.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('168', 'Surfshark', 'AU', 'Per', 'https://xvpn.b-cdn.net/ovpn/au-per.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('169', 'Surfshark', 'US', 'Phx', 'https://xvpn.b-cdn.net/ovpn/us-phx.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('170', 'Surfshark', 'US', 'Phx', 'https://xvpn.b-cdn.net/ovpn/us-phx.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('171', 'Surfshark', 'CZ', 'Prg', 'https://xvpn.b-cdn.net/ovpn/cz-prg.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('172', 'Surfshark', 'CZ', 'Prg', 'https://xvpn.b-cdn.net/ovpn/cz-prg.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('173', 'Surfshark', 'LV', 'Rig', 'https://xvpn.b-cdn.net/ovpn/lv-rig.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('174', 'Surfshark', 'LV', 'Rig', 'https://xvpn.b-cdn.net/ovpn/lv-rig.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('175', 'Surfshark', 'IS', 'Rkv', 'https://xvpn.b-cdn.net/ovpn/is-rkv.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('176', 'Surfshark', 'IS', 'Rkv', 'https://xvpn.b-cdn.net/ovpn/is-rkv.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('177', 'Surfshark', 'IT', 'Rom', 'https://xvpn.b-cdn.net/ovpn/it-rom.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('178', 'Surfshark', 'IT', 'Rom', 'https://xvpn.b-cdn.net/ovpn/it-rom.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('179', 'Surfshark', 'CL', 'San', 'https://xvpn.b-cdn.net/ovpn/cl-san.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('180', 'Surfshark', 'CL', 'San', 'https://xvpn.b-cdn.net/ovpn/cl-san.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('181', 'Surfshark', 'BR', 'Sao', 'https://xvpn.b-cdn.net/ovpn/br-sao.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('182', 'Surfshark', 'BR', 'Sao', 'https://xvpn.b-cdn.net/ovpn/br-sao.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('183', 'Surfshark', 'KR', 'Seo', 'https://xvpn.b-cdn.net/ovpn/kr-seo.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('184', 'Surfshark', 'KR', 'Seo', 'https://xvpn.b-cdn.net/ovpn/kr-seo.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('185', 'Surfshark', 'US', 'Sfo', 'https://xvpn.b-cdn.net/ovpn/us-sfo-mp001.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('186', 'Surfshark', 'US', 'Sfo', 'https://xvpn.b-cdn.net/ovpn/us-sfo-mp001.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('187', 'Surfshark', 'US', 'Sfo', 'https://xvpn.b-cdn.net/ovpn/us-sfo.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('188', 'Surfshark', 'US', 'Sfo', 'https://xvpn.b-cdn.net/ovpn/us-sfo.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('189', 'Surfshark', 'CR', 'Sjn', 'https://xvpn.b-cdn.net/ovpn/cr-sjn.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('190', 'Surfshark', 'CR', 'Sjn', 'https://xvpn.b-cdn.net/ovpn/cr-sjn.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('191', 'Surfshark', 'MK', 'Skp', 'https://xvpn.b-cdn.net/ovpn/mk-skp.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('192', 'Surfshark', 'MK', 'Skp', 'https://xvpn.b-cdn.net/ovpn/mk-skp.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('193', 'Surfshark', 'US', 'Slc', 'https://xvpn.b-cdn.net/ovpn/us-slc.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('194', 'Surfshark', 'US', 'Slc', 'https://xvpn.b-cdn.net/ovpn/us-slc.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('195', 'Surfshark', 'SG', 'Sng', 'https://xvpn.b-cdn.net/ovpn/sg-sng-mp001.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('196', 'Surfshark', 'SG', 'Sng', 'https://xvpn.b-cdn.net/ovpn/sg-sng-mp001.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('197', 'Surfshark', 'SG', 'Sng', 'https://xvpn.b-cdn.net/ovpn/sg-sng-st001.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('198', 'Surfshark', 'SG', 'Sng', 'https://xvpn.b-cdn.net/ovpn/sg-sng-st001.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('199', 'Surfshark', 'SG', 'Sng', 'https://xvpn.b-cdn.net/ovpn/sg-sng-st002.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('200', 'Surfshark', 'SG', 'Sng', 'https://xvpn.b-cdn.net/ovpn/sg-sng-st002.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('201', 'Surfshark', 'SG', 'Sng', 'https://xvpn.b-cdn.net/ovpn/sg-sng-st003.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('202', 'Surfshark', 'SG', 'Sng', 'https://xvpn.b-cdn.net/ovpn/sg-sng-st003.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('203', 'Surfshark', 'SG', 'Sng', 'https://xvpn.b-cdn.net/ovpn/sg-sng-st004.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('204', 'Surfshark', 'SG', 'Sng', 'https://xvpn.b-cdn.net/ovpn/sg-sng-st004.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('205', 'Surfshark', 'SG', 'Sng', 'https://xvpn.b-cdn.net/ovpn/sg-sng.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('206', 'Surfshark', 'SG', 'Sng', 'https://xvpn.b-cdn.net/ovpn/sg-sng.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('207', 'Surfshark', 'BG', 'Sof', 'https://xvpn.b-cdn.net/ovpn/bg-sof.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('208', 'Surfshark', 'BG', 'Sof', 'https://xvpn.b-cdn.net/ovpn/bg-sof.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('209', 'Surfshark', 'RU', 'Spt', 'https://xvpn.b-cdn.net/ovpn/ru-spt.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('210', 'Surfshark', 'RU', 'Spt', 'https://xvpn.b-cdn.net/ovpn/ru-spt.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('211', 'Surfshark', 'LU', 'Ste', 'https://xvpn.b-cdn.net/ovpn/lu-ste.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('212', 'Surfshark', 'LU', 'Ste', 'https://xvpn.b-cdn.net/ovpn/lu-ste.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('213', 'Surfshark', 'US', 'Stl', 'https://xvpn.b-cdn.net/ovpn/us-stl.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('214', 'Surfshark', 'US', 'Stl', 'https://xvpn.b-cdn.net/ovpn/us-stl.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('215', 'Surfshark', 'SE', 'Sto', 'https://xvpn.b-cdn.net/ovpn/se-sto.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('216', 'Surfshark', 'SE', 'Sto', 'https://xvpn.b-cdn.net/ovpn/se-sto.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('217', 'Surfshark', 'AU', 'Syd', 'https://xvpn.b-cdn.net/ovpn/au-syd.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('218', 'Surfshark', 'AU', 'Syd', 'https://xvpn.b-cdn.net/ovpn/au-syd.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('219', 'Surfshark', 'TW', 'Tai', 'https://xvpn.b-cdn.net/ovpn/tw-tai.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('220', 'Surfshark', 'TW', 'Tai', 'https://xvpn.b-cdn.net/ovpn/tw-tai.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('221', 'Surfshark', 'AL', 'Tia', 'https://xvpn.b-cdn.net/ovpn/al-tia.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('222', 'Surfshark', 'AL', 'Tia', 'https://xvpn.b-cdn.net/ovpn/al-tia.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('223', 'Surfshark', 'LY', 'Tip', 'https://xvpn.b-cdn.net/ovpn/ly-tip.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('224', 'Surfshark', 'LY', 'Tip', 'https://xvpn.b-cdn.net/ovpn/ly-tip.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('225', 'Surfshark', 'EE', 'Tll', 'https://xvpn.b-cdn.net/ovpn/ee-tll.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('226', 'Surfshark', 'EE', 'Tll', 'https://xvpn.b-cdn.net/ovpn/ee-tll.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('227', 'Surfshark', 'IL', 'Tlv', 'https://xvpn.b-cdn.net/ovpn/il-tlv.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('228', 'Surfshark', 'IL', 'Tlv', 'https://xvpn.b-cdn.net/ovpn/il-tlv.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('229', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st001.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('230', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st001.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('231', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st002.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('232', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st002.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('233', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st003.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('234', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st003.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('235', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st004.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('236', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st004.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('237', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st005.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('238', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st005.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('239', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st006.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('240', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st006.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('241', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st007.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('242', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok-st007.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('243', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('244', 'Surfshark', 'JP', 'Tok', 'https://xvpn.b-cdn.net/ovpn/jp-tok.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('245', 'Surfshark', 'CA', 'Tor', 'https://xvpn.b-cdn.net/ovpn/ca-tor-mp001.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('246', 'Surfshark', 'CA', 'Tor', 'https://xvpn.b-cdn.net/ovpn/ca-tor-mp001.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('247', 'Surfshark', 'CA', 'Tor', 'https://xvpn.b-cdn.net/ovpn/ca-tor.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('248', 'Surfshark', 'CA', 'Tor', 'https://xvpn.b-cdn.net/ovpn/ca-tor.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('249', 'Surfshark', 'US', 'Tpa', 'https://xvpn.b-cdn.net/ovpn/us-tpa.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('250', 'Surfshark', 'US', 'Tpa', 'https://xvpn.b-cdn.net/ovpn/us-tpa.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('251', 'Surfshark', 'KZ', 'Ura', 'https://xvpn.b-cdn.net/ovpn/kz-ura.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('252', 'Surfshark', 'KZ', 'Ura', 'https://xvpn.b-cdn.net/ovpn/kz-ura.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('253', 'Surfshark', 'AT', 'Vie', 'https://xvpn.b-cdn.net/ovpn/at-vie.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('254', 'Surfshark', 'AT', 'Vie', 'https://xvpn.b-cdn.net/ovpn/at-vie.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('255', 'Surfshark', 'ES', 'Vlc', 'https://xvpn.b-cdn.net/ovpn/es-vlc.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('256', 'Surfshark', 'ES', 'Vlc', 'https://xvpn.b-cdn.net/ovpn/es-vlc.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('257', 'Surfshark', 'PL', 'Waw', 'https://xvpn.b-cdn.net/ovpn/pl-waw.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('258', 'Surfshark', 'PL', 'Waw', 'https://xvpn.b-cdn.net/ovpn/pl-waw.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('259', 'Surfshark', 'HR', 'Zag', 'https://xvpn.b-cdn.net/ovpn/hr-zag.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('260', 'Surfshark', 'HR', 'Zag', 'https://xvpn.b-cdn.net/ovpn/hr-zag.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO'), ('261', 'Surfshark', 'CH', 'Zur', 'https://xvpn.b-cdn.net/ovpn/ch-zur.prod.surfshark.com_tcp.ovpn', 'ACTIVE', 'up', 'NO'), ('262', 'Surfshark', 'CH', 'Zur', 'https://xvpn.b-cdn.net/ovpn/ch-zur.prod.surfshark.com_udp.ovpn', 'ACTIVE', 'up', 'NO');";
    $sqlite3->exec($sql);
}
/* get xciptv annoucnement data count */
$result = $sqlite3->query("SELECT COUNT(*) AS count FROM xc_xciptv_ann");
$row = $result->fetchArray();
$row_count = $row['count'];
if ($row_count == 0) {
    /* insert `default` xciptv announcement data if not exists */
    /* TODO: Cleanup */
    $sql = "INSERT INTO xc_xciptv_ann('id', 'announcement', 'status', 'channel', 'expire', 'interval', 'disappear') VALUES ('1', 'Announcement Here', 'INACTIVE', 'ALL', '2022-12-31 00:00:00', '1', '5');";
    $sqlite3->exec($sql);
}

/* get xciptv ort settings data count */
$result = $sqlite3->query("SELECT COUNT(*) AS count FROM xc_ort_settings");
$row = $result->fetchArray();
$row_count = $row['count'];
if ($row_count == 0) {
    /* insert `default` xciptv ort settings data if not exists */
    /* TODO: Cleanup */
    $sql = "INSERT INTO xc_ort_settings('vlc_hw', 'last_volume_vlc', 'player_vlc_buffer', 'video_resize_vlc', 'video_subtitles_vlc', 'exo_hw', 'last_volume_exo', 'player_exo_buffer', 'video_resize_exo', 'video_subtitles_exo') VALUES ('yes', '100', '5000', '0', 'yes', 'yes', '100', '50000', '0', 'no');";
    $sqlite3->exec($sql);
}

/* get xciptv tvsg settings data count */
$result = $sqlite3->query("SELECT COUNT(*) AS count FROM tvsg_settings");
$row = $result->fetchArray();
$row_count = $row['count'];
if ($row_count == 0) {
    /* insert `default` tvsg settings data if not exists */
    /* TODO: Cleanup */
    $sql = "INSERT INTO tvsg_settings('widget_id', 'border_color', 'background_color', 'text_color') VALUES ('5cc316f797659', '#1d23dd', '#ffffff', '#000000');";
    $sqlite3->exec($sql);
}

$sql = "SELECT * FROM profile ";
$sql .= "WHERE id = '1';";
$result = $sqlite3->query($sql);
$profile_data = $result->fetchArray();

$sql = "SELECT * FROM profile ";
$sql .= "WHERE id = '2';";
$result = $sqlite3->query($sql);
$profile_data = $result->fetchArray();

$sql = "SELECT * FROM panel;";
$result = $sqlite3->query($sql);
$panel_data = $result->fetchArray();

$sql = "SELECT * FROM snoop_logs;";
$snoop_logs = $sqlite3->query($sql);

$sql = "SELECT * FROM tvsg_settings;";
$result = $sqlite3->query($sql);
$tvsg_settings = $result->fetchArray();

$sql = "SELECT * FROM xc_ort_settings;";
$result = $sqlite3->query($sql);
$xciptv_ort_settings = $result->fetchArray();

$sql = "SELECT * FROM xc_xciptv_ann;";
$result = $sqlite3->query($sql);
$xciptv_ann_data = $result->fetchArray();

$sql = "SELECT * FROM xc_xciptv_lic;";
$result = $sqlite3->query($sql);
$xciptv_lic_data = $result->fetchArray();

$sql = "SELECT * FROM xc_xciptv_ads;";
$result = $sqlite3->query($sql);
$xciptv_ads_data = $result->fetchArray();

$sql = "SELECT * FROM xc_xciptv_app ";
$sql .= "WHERE id = '1';";
$result = $sqlite3->query($sql);
$xciptv_app_data = $result->fetchArray();

$sql = "SELECT * FROM xc_xciptv_connv2;";
$xciptv_connv2_data = $sqlite3->query($sql);

$sql = "SELECT * FROM xc_domains_ottrun;";
$service_ottrun_data = $sqlite3->query($sql);

$sql = "SELECT * FROM extra_customers_ottrun;";
$customer_ottrun_data = $sqlite3->query($sql);

$sql = "SELECT * FROM ovpn_credentials;";
$ovpn_credentials = $sqlite3->query($sql);

$sql = "SELECT * FROM ovpn_config;";
$ovpn_config = $sqlite3->query($sql);