<?php
session_start();

include('assets/includes/db.php');

if (!isset($_SESSION['loggedin']) && $_SESSION['loggedin'] != true) {
    header("location: logout.php");
}

?>
<!doctype html>
<html lang="en">

<head>

    <?php include('assets/includes/title-meta.php') ?>

    <?php include('assets/includes/head-css.php') ?>

</head>

<body data-sidebar="dark">

    <!-- Loader -->
    <div id="preloader">
        <div id="status">
            <div class="spinner">
                <i class="ri-loader-line spin-icon"></i>
            </div>
        </div>
    </div>

    <div id="layout-wrapper">

        <?php include('assets/includes/topbar.php') ?>

        <?php include('assets/includes/sidebar.php') ?>

        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-flex align-items-center justify-content-between">
                                <h4 class="mb-0"> </h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">OTTRun XCIPTV</a></li>
                                        <li class="breadcrumb-item active">Connections</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">

                                    <h4 class="card-title">Application Connections</h4>
                                    <p class="card-title-desc">View the connection history of the applications.</p>

                                    <br />

                                    <div class="col-12 d-flex mx-auto">

                                        <div class="card-body">
                                            <div class="col-md-12">

                                                <div class="row">
                                                    <div class="card col-md-12">
                                                        <br>
                                                        <table id="datatable1" class="table table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <th>User</th>
                                                                    <th>App name</th>
                                                                    <th>App Package</th>
                                                                    <th>Device Type</th>
                                                                    <th>Version</th>
                                                                    <th hidden>appid</th>
                                                                    <th hidden>customerid</th>
                                                                    <th hidden>did</th>
                                                                    <th>Datetime</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                            <?php while ($row = $xciptv_connv2_data->fetchArray()) { ?>
                                                                <tr>
                                                                    <td><?php echo $row['userid']; ?></td>
                                                                    <td><?php echo $row['an']; ?></td>
                                                                    <td><?php echo $row['p']; ?></td>
                                                                    <td><?php echo $row['device_type']; ?></td>
                                                                    <td><?php echo $row['version']; ?></td>
                                                                    <td hidden><?php echo $row['appid']; ?></td>
                                                                    <td hidden><?php echo $row['customerid']; ?></td>
                                                                    <td hidden><?php echo $row['did']; ?></td>
                                                                    <td><?php echo $row['datetime']; ?></td>
                                                                </tr>
                                                            <?php } ?>
                                                            </tbody>
                                                        </table>
                                                        <br>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <?php include('assets/includes/footer.php'); ?>
        </div>

    </div>

    <?php include('assets/includes/right-sidebar.php'); ?>

    <?php include('assets/includes/vendor-scripts.php'); ?>

    <script src="./assets/js/app.js"></script>

</body>

</html>