# Select for DataTables with styling for [Bootstrap5](https://getbootstrap.com/)

This package contains a built distribution of the [Select extension](https://datatables.net/extensions/select) for [DataTables](https://datatables.net/) with styling for [Bootstrap5](https://getbootstrap.com/).

Select provides table item selection capabilities - rows, columns and cells can be selected individually or collectively. Complex selection operations such as operating system style selection (ctrl/cmd and shift click) for multiple rows can be enabled with a single option for a DataTable.


## Installation

### Browser

For inclusion of this library using a standard `<script>` tag, rather than using this package, it is recommended that you use the [DataTables download builder](//datatables.net/download) which can create CDN or locally hosted packages for you, will all dependencies satisfied.

### npm

```
npm install datatables.net-select-bs5
```

ES3 Syntax
```
var $ = require( 'jquery' );
var dt = require( 'datatables.net-select-bs5' )( window, $ );
```

ES6 Syntax
```
import 'datatables.net-select-bs5'
```

### bower

```
bower install --save datatables.net-select-bs5
```



## Documentation

Full documentation and examples for Select can be found [on the website](https://datatables.net/extensions/select).


## Bug / Support

Support for DataTables is available through the [DataTables forums](//datatables.net/forums) and [commercial support options](//datatables.net/support) are available.


### Contributing

If you are thinking of contributing code to DataTables, first of all, thank you! All fixes, patches and enhancements to DataTables are very warmly welcomed. This repository is a distribution repo, so patches and issues sent to this repo will not be accepted. Instead, please direct pull requests to the [DataTables/Select](http://github.com/DataTables/Select). For issues / bugs, please direct your questions to the [DataTables forums](//datatables.net/forums).


## License

This software is released under the [MIT license](//datatables.net/license). You are free to use, modify and distribute this software, but all copyright information must remain.

