
// assets/js/auth.js
(function(){
  const STORAGE_KEY = "cockpit_session_v1";

  function saveSession(session) {
    localStorage.setItem(STORAGE_KEY, JSON.stringify(session));
  }
  function getSession() {
    try { return JSON.parse(localStorage.getItem(STORAGE_KEY) || "null"); }
    catch(e){ return null; }
  }
  function clearSession() {
    localStorage.removeItem(STORAGE_KEY);
  }

  // Simple in-memory users. Replace with your backend calls if you add one later.
  const USERS = {
    "superadmin": { password: "superadmin!23", role: "superadmin" },
    "admin": { password: "admin!23", role: "admin" }
  };

  // Expose minimal API
  window.CockpitAuth = {
    login(username, password){
      username = (username || "").trim().toLowerCase();
      if (!USERS[username]) throw new Error("Invalid username or password.");
      if (USERS[username].password !== password) throw new Error("Invalid username or password.");
      const session = { username, role: USERS[username].role, ts: Date.now() };
      saveSession(session);
      return session;
    },
    logout(){
      clearSession();
      const target = "/page_login.html";
      if (location.pathname.endsWith("page_login.html")) return;
      location.href = target;
    },
    session(){
      return getSession();
    },
    hasRole(required){
      const s = getSession();
      if (!s) return false;
      if (required === "admin") return s.role === "admin" || s.role === "superadmin";
      if (required === "superadmin") return s.role === "superadmin";
      return !!s; // default: any logged in user
    },
    enforceAuth(){
      // Determine required role from <meta name="required-role" content="...">
      let required = "admin";
      const meta = document.querySelector('meta[name="required-role"]');
      if (meta && meta.content) required = meta.content.trim().toLowerCase();

      const s = getSession();
      if (!s) {
        // Not logged in
        if (!location.pathname.endsWith("page_login.html")) {
          location.href = "/page_login.html";
        }
        return;
      }
      // Has to meet role
      if (!window.CockpitAuth.hasRole(required)) {
        // If user is admin and page requires superadmin, bounce to a safer default page
        alert("You do not have permission to access this page.");
        location.href = "/index.html";
        return;
      }

      // Wire up logout buttons if present
      const logoutEls = document.querySelectorAll("[data-action='logout']");
      logoutEls.forEach(el => el.addEventListener("click", e => {
        e.preventDefault();
        window.CockpitAuth.logout();
      }));

      // Optional: inject user chip if there's a header
      const header = document.querySelector(".header, header, .topbar, .navbar, nav");
      if (header && !document.querySelector("#cockpit-userchip")) {
        const chip = document.createElement("div");
        chip.id = "cockpit-userchip";
        chip.style.marginLeft = "auto";
        chip.style.display = "flex";
        chip.style.gap = "0.75rem";
        chip.style.alignItems = "center";
        chip.style.fontSize = "0.9rem";
        chip.innerHTML = `<span>Signed in as <strong>${s.username}</strong> (${s.role})</span>
          <a href="#" data-action="logout" style="text-decoration:underline;">Logout</a>`;
        header.appendChild(chip);
        chip.querySelector("[data-action='logout']").addEventListener("click", (e)=>{
          e.preventDefault(); window.CockpitAuth.logout();
        });
      }
    }
  };

  // Auto-enforce on DOMContentLoaded for non-login pages
  document.addEventListener("DOMContentLoaded", function(){
    if (!location.pathname.endsWith("page_login.html")) {
      window.CockpitAuth.enforceAuth();
    }
  });
})();
